import pygame
pygame.display.set_mode([100,100])
import random
import math

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 16 fog"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    self.zval = -3
    
    #instance variables to be replaced with objects
    self.xrot = 0
    self.yrot = 0
    self.xspeed = 0
    self.yspeed = 0    
    
    self.fogmodes = [GL_EXP,GL_EXP2,GL_LINEAR]
    self.fogfilter = self.fogmodes[0]
    self.fogcolor = [.5,.5,.5,1]
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Crate.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(2)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #mipmapped texture
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    gluBuild2DMipmaps(GL_TEXTURE_2D,3,self.textures[0].get_width(),self.textures[0].get_height(),GL_RGB,GL_UNSIGNED_BYTE,idat)
    #glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.textures[0] = None
    #self.texloaded = True
    self.textures = []
  def initGL(self):
    if not self.tnames:
      self.loadGLTextures()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(*self.fogcolor)
    
    #fog
    glFogi(GL_FOG_MODE,self.fogfilter)
    glFogfv(GL_FOG_COLOR,self.fogcolor)
    glFogf(GL_FOG_DENSITY,.35)
    glHint(GL_FOG_HINT,GL_DONT_CARE)
    glFogf(GL_FOG_START,1)
    glFogf(GL_FOG_END,5)
    glEnable(GL_FOG)
    
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambientlight)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuselight)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lightpos)
    glEnable(GL_LIGHT1)
    
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glEnable(GL_COLOR_MATERIAL)
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,-5)
    glRotatef(self.xrot,1,0,0)
    glRotatef(self.yrot,0,1,0)
    #select texture
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glBegin(GL_QUADS)
    #front
    glNormal3f(0,0,1)
    glTexCoord2f(0,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,1)
    #back
    glNormal3f(0,0,-1)
    glTexCoord2f(0,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(-1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,-1)
    #left
    glNormal3f(-1,0,0)
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,1);glVertex3f(-1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #right
    glNormal3f(1,0,0)
    glTexCoord2f(0,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,1)
    #top
    glNormal3f(0,1,0)
    glTexCoord2f(0,0);glVertex3f(-1,1,1)
    glTexCoord2f(1,0);glVertex3f(1,1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #bottom
    glNormal3f(0,-1,0)
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,-1,1)
    glTexCoord2f(0,1);glVertex3f(-1,-1,1)
    glEnd()
    self.xrot += self.xspeed
    self.yrot += self.yspeed

screen = Screen()
screen.resize()

piover180 = math.pi/180.0
running = 1
c = pygame.time.Clock()
while running:
  c.tick(60)
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
      if e.key==pygame.K_g:
        i = screen.fogmodes.index(screen.fogfilter)
        i += 1
        if i >= len(screen.fogmodes):
          i = 0
        screen.fogfilter = screen.fogmodes[i]
        print screen.fogfilter
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    pass
  if keys[pygame.K_PAGEDOWN]:
    pass
  if keys[pygame.K_RIGHT]:
    screen.yspeed+=.1
  if keys[pygame.K_LEFT]:
    screen.yspeed-=.1
  if keys[pygame.K_UP]:
    screen.xspeed += .1
  if keys[pygame.K_DOWN]:
    screen.xspeed -=.1
